/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.report;

import com.quantumdata.fmteditor.report.FmtTableEntry;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmtReport
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int VERSION = 4;
    private String m_fileName;
    private String[] m_colNames;
    private int[] m_colIndexes;
    private List<Row> m_rows = new LinkedList<Row>();

    public FmtReport() {
        this("");
    }

    public FmtReport(String string) {
        this.m_fileName = string;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String string) {
        this.m_fileName = string;
    }

    public void setColNames(String[] stringArray) {
        this.m_colNames = stringArray;
    }

    public String[] getColNames() {
        return this.m_colNames;
    }

    public void setColIndexes(int[] nArray) {
        this.m_colIndexes = nArray;
    }

    public int[] getColIndexes() {
        return this.m_colIndexes;
    }

    public void clearRows() {
        this.m_rows.clear();
    }

    public void addRow(FmtTableEntry fmtTableEntry) {
        double[] dArray = new double[this.m_colNames.length];
        for (int i = 0; i < this.m_colNames.length; ++i) {
            dArray[i] = fmtTableEntry.getValue(i).getDouble();
        }
        this.m_rows.add(new Row(fmtTableEntry.path(), fmtTableEntry.name(), dArray));
    }

    public List<Row> getRows() {
        return this.m_rows;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        int n2 = objectInput.readInt();
        if (n2 < 4) {
            throw new IOException("File version too old");
        }
        int n3 = objectInput.readInt();
        this.m_colNames = new String[n3];
        for (n = 0; n < n3; ++n) {
            this.m_colNames[n] = objectInput.readUTF();
        }
        n3 = objectInput.readInt();
        this.m_colIndexes = new int[n3];
        for (n = 0; n < n3; ++n) {
            this.m_colIndexes[n] = objectInput.readInt();
        }
        n3 = objectInput.readInt();
        for (n = 0; n < n3; ++n) {
            String string = objectInput.readUTF();
            String string2 = objectInput.readUTF();
            double[] dArray = new double[this.m_colNames.length];
            for (int i = 0; i < this.m_colNames.length; ++i) {
                dArray[i] = objectInput.readDouble();
            }
            this.m_rows.add(new Row(string, string2, dArray));
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(4);
        objectOutput.writeInt(this.m_colNames.length);
        for (String string : this.m_colNames) {
            objectOutput.writeUTF(string);
        }
        objectOutput.writeInt(this.m_colIndexes.length);
        for (String string : (Object)this.m_colIndexes) {
            objectOutput.writeInt((int)string);
        }
        objectOutput.writeInt(this.m_rows.size());
        for (Row row : this.m_rows) {
            objectOutput.writeUTF(row.m_path);
            objectOutput.writeUTF(row.m_name);
            for (double d : row.m_values) {
                objectOutput.writeDouble(d);
            }
        }
    }

    public class Row {
        protected String m_name;
        protected String m_path;
        protected double[] m_values;

        public Row(String string, String string2, double[] dArray) {
            this.m_path = string;
            this.m_name = string2;
            this.m_values = dArray;
        }

        public String getPath() {
            return this.m_path;
        }

        public String getName() {
            return this.m_name;
        }

        public double[] getValues() {
            return this.m_values;
        }
    }
}

